/*
 * Decompiled with CFR 0.152.
 */
import cds.aladin.AladinData;
import cds.aladin.AladinException;
import cds.aladin.AladinPlugin;

public class ImageCreationPlug
extends AladinPlugin {
    @Override
    public String menu() {
        return "Image creation with a calibration";
    }

    @Override
    public String description() {
        return "PLUGIN TUTORIAL:\nThis plugin is an example of an image plane creation.\nIt will create an image and will provide an astrometrical solution for it.";
    }

    @Override
    public String author() {
        return "Pierre Fernique [CDS]";
    }

    @Override
    public String version() {
        return "1.0 - January 2007";
    }

    @Override
    public String url() {
        return "http://aladin.u-strasbg.fr/java/Plugins/ImageCreationPlug.java";
    }

    @Override
    public String category() {
        return "Plugin tutorial/Image";
    }

    @Override
    public void exec() {
        try {
            AladinData ad = this.aladin.createAladinData("My Image");
            double[][] pix = new double[512][512];
            for (int x = 0; x < 512; ++x) {
                for (int y = 0; y < 512; ++y) {
                    pix[x][y] = x == 255 || y == 255 ? 0.0 : (x == 0 && y == 0 ? 86.0 : (x > 300 && y > 300 && y % 2 == 0 && x % 2 == 0 ? (double)(x * y % 255) : 255.0));
                }
            }
            ad.setPixels(pix, 16);
            String header = "SIMPLE  = T\nBITPIX  = 16\nNAXIS   = 2\nNAXIS1  = 512\nNAXIS2  = 512\n";
            ad.setFitsHeader(header);
        }
        catch (AladinException e) {
            e.printStackTrace();
        }
    }
}

